#ifndef __BSP_TIMER_H
#define __BSP_TIMER_H

#include "common.h"


/// Test pad for timer pwm

#define PWM_CH1_PERIOD             1000

#define PAD_TIM1_PWM_CH1           3
/// Test pad for timer pwm complementary
#define PAD_TIM1_PWM_CH1N          5
/// Test mux for timer pwm
#define MUX_TIM1_PWM_CH1           PINMUX_PAD3_TIMER1_OUT1_CFG

/// Test mux for timer pwm complementary
#define MUX_TIM1_PWM_CH1N          PINMUX_PAD5_TIMER1_OUTN1_CFG

// Test pad for timer capature
#define PAD_TIM0_CAP_CH1           24
// Test mux for timer capature
#define MUX_TIM0_CAP_CH1           PINMUX_PAD24_TIMER0_IO1_CFG

/// Number of capture
#define CAP_SAMPLE_NUM             30


#define TIMER_32BIT_MASTER   OM_TIM1

#define TIMER_32BIT_SLAVE    OM_TIM2



extern void bsp_tim_count_init(void);

extern void bsp_tim_count_demo(void);

extern void bsp_tim_pwm_in_init(void);

extern void bsp_tim_pwm_in_demo(void);

extern void bsp_tim_pwm_out_init(void);

extern void bsp_tim_pwm_out_demo(void);

extern void bsp_tim_capture_init(void);

extern void bsp_tim_capture_demo(void);

extern void bsp_tim_pwm_complementary_init(void);

extern void bsp_tim_pwm_complementary_demo(void);

extern void bsp_tim_count_32bit_init(void);

extern void bsp_tim_count_32bit_demo(void);

#endif
