#ifndef __BSP_KEY_H
#define __BSP_KEY_H

#include "common.h"


#define PAD_KEY1  			24
#define MUX_KEY1	  		PINMUX_GPIO_MODE_CFG

#define PAD_KEY2  			25
#define MUX_KEY2	  		PINMUX_GPIO_MODE_CFG


typedef enum
{
    VALID_LEVEL_LOW  = 0,
    
    VALID_LEVEL_HIGH = 1,
} key_valid_level_typedef;


typedef enum
{
    KEY_STATE_RELEASE = 0,
    
    KEY_STATE_PRESS   = 1,
} key_state_typedef;


typedef struct
{
    uint16_t                key_pin;
    
    key_valid_level_typedef key_valid_level;
    
    uint16_t                key_count;
    
    uint16_t                key_press_count;
    
    uint16_t                key_release_count;
    
    key_state_typedef       key_state;
} key_typedef;






extern void bsp_key_check_init(void);

extern void bsp_key_check_demo(void);


extern void bsp_key_int_init(void);

extern void bsp_key_int_demo(void);


#endif
