#include "bsp.h"

uint8_t eeprom_send_data[20] = {0};

uint8_t eeprom_read_data[20] = {0};

uint8_t eeprom_index = 0;

#define EEPROM_READ_WRITE_ADDR       0

#define EEPROM_DATA_NUM   16

static const pin_config_t eeprom_cfg_cnt [] = 
{
	{PAD_EEPROM_SCL, {MUX_EEPROM_SCL}, PMU_PIN_MODE_OD, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_EEPROM_SDA, {MUX_EEPROM_SDA}, PMU_PIN_MODE_OD, PMU_PIN_DRIVER_CURRENT_NORMAL},
};


void bsp_i2c_eeprom_init(void)
{
	i2c_config_t cfg = 
	{
        .mode  = I2C_MODE_MASTER,        // 7-bit addressing mode
        .speed = I2C_SPEED_100K,
    };
	
	drv_pin_init(eeprom_cfg_cnt, sizeof(eeprom_cfg_cnt) / sizeof(eeprom_cfg_cnt[0]));

	drv_i2c_init(EEPROM_I2C, &cfg);
}


void eeprom_read(uint8_t ReadAddr,uint8_t *pBuffer,uint16_t NumToRead)
{
    uint8_t read_addr = ReadAddr;
	
    drv_i2c_master_read(EEPROM_I2C, (EEPROM_ADDR>>1), &read_addr, 1, pBuffer, NumToRead,1000);
} 


void eeprom_write(uint8_t WriteAddr,uint8_t *pBuffer,uint16_t NumToWrite)
{
	uint8_t data[NumToWrite+1];
	
	data[0] = WriteAddr;
	
	for (uint8_t i = 0; i < NumToWrite; i++) 
	{
		data[i + 1] = pBuffer[i];
	}
	
    drv_i2c_master_write(EEPROM_I2C, (EEPROM_ADDR>>1), data, NumToWrite+1,1000);	
}



void bsp_i2c_eeprom_demo(void)
{
	uint8_t i = 0;
	
	for(i = 0;i < EEPROM_DATA_NUM;i++)
	{
		eeprom_send_data[i] = i + eeprom_index;
	}
	
	eeprom_write(EEPROM_READ_WRITE_ADDR,eeprom_send_data,EEPROM_DATA_NUM);
	
	drv_dwt_delay_ms(50);
	
	eeprom_read(EEPROM_READ_WRITE_ADDR,eeprom_read_data,EEPROM_DATA_NUM);
    
    om_printf("\r\n\r\n");
    
	for(i = 0;i < EEPROM_DATA_NUM;i++)
	{
		om_printf("read_data[%d] is %d \r\n",i,eeprom_read_data[i]);
	}
	
	eeprom_index++;	
}



