#include "bsp.h"

void bsp_aes128_demo(void)
{
	uint8_t input[16] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF};
	
    uint8_t key[16]   = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};
	
    uint8_t expect[16] = {0x69, 0xc4, 0xe0, 0xd8, 0x6a, 0x7b, 0x04, 0x30, 0xd8, 0xcd, 0xb7, 0x80, 0x70, 0xb4, 0xc5, 0x5a};
	
    uint8_t res[16] = {0};

    om_array_reversal(input, sizeof(input));
	
    om_array_reversal(key, sizeof(key));
	
    om_array_reversal(expect, sizeof(expect));

    drv_aes128_hw_encrypt(key, input, res);

    for (uint8_t i = 0; i < 16; i++) 
	{
        if (expect[i] != res[i]) 
		{
            om_printf("aes128 encrypt FAIL\r\n");
			
            return;
        }
    }

    om_printf("aes128 encrypt PASS\r\n");
}



void bsp_aes256_demo(void)
{
	uint8_t input[16] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF};
	
    uint8_t key[32]   = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
                         0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F};
	
    uint8_t expect[16] = {0x8e, 0xa2, 0xb7, 0xca, 0x51, 0x67, 0x45, 0xbf, 0xea, 0xfc, 0x49, 0x90, 0x4b, 0x49, 0x60, 0x89};
	
    uint8_t res[16] = {0};

    om_array_reversal(input, sizeof(input));
	
    om_array_reversal(key, sizeof(key));
	
    om_array_reversal(expect, sizeof(expect));

    drv_aes256_hw_encrypt(key, input, res);

    for (uint8_t i = 0; i < 16; i++) 
	{
        if (expect[i] != res[i]) 
		{
            om_printf("aes256 encrypt FAIL\r\n");
			
            return;
        }
    }

    om_printf("aes256 encrypt PASS\r\n");
}




