#include "bsp.h"


test_demo_typedef bsp_index = BSP_LED;

void bsp_init(void)
{
    switch(bsp_index)
    {
        case BSP_LED:
            
            bsp_led_init();
        
            break;
        
        case BSP_KEY_CHECK:
            
            bsp_led_init();
        
            bsp_key_check_init();
        
            break;
		
		case BSP_KEY_INT:
            
            bsp_led_init();
        
            bsp_key_int_init();
        
            break;
        
        case BSP_TIM_COUNT:
            
            bsp_led_init();
        
            bsp_tim_count_init();
        
            break;
		
		case BSP_TIM_PWM_IN:
            
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
		
			bsp_tim_pwm_in_init();
        
			bsp_tim_pwm_out_init();
		
            break;
		
		case BSP_TIM_PWM_OUT:
            
            bsp_tim_pwm_out_init();
        
            break;
		
		case BSP_TIM_CAPTURE:
            
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
		
			bsp_tim_capture_init();
        
			bsp_tim_pwm_out_init();
		
            break;
		
		case BSP_TIM_PWM_OUT_COMP:
			
			bsp_tim_pwm_complementary_init();
		
			break;
		
		
		case BSP_TIM_COUNT_32BIT:
			
			bsp_led_init();
		
			bsp_tim_count_32bit_init();
		
			break;
		
		case BSP_LPTIM_FREE_RUNNING_TOGGLE:
			
			bsp_lptim_free_running_init(LP_TIM_UFOA_TOGGLE);
		
			break;
		
		
		case BSP_LPTIM_ONESHOT_TOGGLE:
			
			bsp_lptim_oneshot_init(LP_TIM_UFOA_TOGGLE);
		
			break;
		
		
		case BSP_LPTIM_BUFFERED_TOGGLE:
			
			bsp_lptim_buffered_init(LP_TIM_UFOA_TOGGLE);
		
			break;
		
		
		case BSP_LPTIM_DOUBLE_TOGGLE:
			
			bsp_lptim_double_init(LP_TIM_UFOA_TOGGLE);
		
			break;
		
		
		case BSP_LPTIM_FREE_RUNNING_PULSE:
			
			bsp_lptim_free_running_init(LP_TIM_UFOA_PULSE);
		
			break;
		
		
		case BSP_LPTIM_ONESHOT_PULSE:
			
			bsp_lptim_oneshot_init(LP_TIM_UFOA_PULSE);
		
			break;
		
		
		case BSP_LPTIM_BUFFERED_PULSE:
			
			bsp_lptim_buffered_init(LP_TIM_UFOA_PULSE);
		
			break;
		
		
		case BSP_LPTIM_DOUBLE_PULSE:
			
			bsp_lptim_double_init(LP_TIM_UFOA_PULSE);
		
			break;
		
		
		case BSP_LPTIM_FREE_RUNNING_PWM:
			
			bsp_lptim_free_running_init(LP_TIM_UFOA_PWM);
		
			break;
		
		
		case BSP_LPTIM_ONESHOT_PWM:
			
			bsp_lptim_oneshot_init(LP_TIM_UFOA_PWM);
		
			break;
		
		
		case BSP_LPTIM_BUFFERED_PWM:
			
			bsp_lptim_buffered_init(LP_TIM_UFOA_PWM);
		
			break;
		
		
		case BSP_LPTIM_DOUBLE_PWM:
			
			bsp_lptim_double_init(LP_TIM_UFOA_PWM);
		
			break;
		
		case BSP_PMU_TIMER:
			
			bsp_uart0_gpio_init();
        
            shell_init(NULL);
		
			bsp_pmu_tim_init();
		
			break;
		
		
        case BSP_WDT_INTDIS_FEED:
            
            bsp_led_init();
        
            bsp_wdt_intdis_feed_init();
        
            break;
        
        case BSP_WDT_INTDIS_RST:
            
            bsp_led_init();
        
            bsp_wdt_intdis_rst_init();
        
            break;
        
        case BSP_WDT_INTEN_FEED:
            
            bsp_led_init();
        
            bsp_wdt_inten_feed_init();
        
            break;
        
        case BSP_WDT_INTEN_RST:
            
            bsp_led_init();
        
            bsp_wdt_inten_rst_init();
        
            break;
        
        
        
        case BSP_UART_BLOCK:
            
            bsp_uart_block_init();
        
            break;
		
		
		case BSP_UART_INT:
            
            bsp_uart_int_init();
        
            break;
		
		case BSP_UART_DMA:
            
            bsp_uart_dma_init();
        
            break;
		
		case BSP_UART_FLOW:
            
            bsp_uart_flow_init();
        
            break;
		
		
		case BSP_UART_EX_INT:
            
            bsp_uart_ex_int_init();
        
            break;
		
        
		case BSP_I2C_EEPROM:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_i2c_eeprom_init();
        
			break;
		
		case BSP_SPI_W25QXX:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_spi_w25qxx_init();
        
			break;
        
        case BSP_ADC_CHECK:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_adc_check_init();
        
			break;
        
        case BSP_ADC_INT:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_adc_int_init();
        
			break;
        
        case BSP_ADC_DMA:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_adc_dma_init();
        
			break;
        
        case BSP_ADC_TEMP:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_adc_temp_init();
        
			break;
        
        case BSP_ADC_BAT:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_adc_bat_init();
        
			break;
        
        case BSP_RNG:
			 
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
			break;
        
        case BSP_SFLASH:
			 
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_sflash_init();
        
			break;
		
        case BSP_RTC:
			
            bsp_uart0_gpio_init();
        
            shell_init(NULL);
        
            bsp_rtc_init();
        
			break;
        
		
		case BSP_AES128:
			
			bsp_uart0_gpio_init();
	
			shell_init(NULL);
				
			break;
		
		case BSP_AES256:
			
			bsp_uart0_gpio_init();
	
			shell_init(NULL);

			break;
        
        default:
            
            break;
        
    }
}


void bsp_demo(void)
{
    switch(bsp_index)
    {
        case BSP_LED:
            
            bsp_led_demo();
        
            break;
        
        case BSP_KEY_CHECK:
            
            bsp_key_check_demo();
        
            break;
		
		case BSP_KEY_INT:
            
            bsp_key_int_demo();
        
            break;
        
        case BSP_TIM_COUNT:
            
            bsp_tim_count_demo();
        
            break;
		
		case BSP_TIM_PWM_IN:
            
            bsp_tim_pwm_in_demo();
        
			bsp_tim_pwm_out_demo();
		
            break;
		
		case BSP_TIM_PWM_OUT:
            
            bsp_tim_pwm_out_demo();
        
            break;
		
		case BSP_TIM_CAPTURE:
			
			bsp_tim_capture_demo();
		
			bsp_tim_pwm_out_demo();
        
            break;
		
		case BSP_TIM_PWM_OUT_COMP:
			
			bsp_tim_pwm_complementary_demo();
		
			break;
		
		case BSP_TIM_COUNT_32BIT:
			
			bsp_tim_count_32bit_demo();
		
			break;
		
		case BSP_PMU_TIMER:
			
			bsp_pmu_tim_demo();
		
			break;
		
		
        case BSP_WDT_INTDIS_FEED:
            
            bsp_wdt_intdis_feed_demo();
        
            break;
        
        case BSP_WDT_INTDIS_RST:
            
            bsp_wdt_intdis_rst_demo();
        
            break;
        
        case BSP_WDT_INTEN_FEED:
            
            bsp_wdt_inten_feed_demo();
        
            break;
        
        case BSP_WDT_INTEN_RST:
            
            bsp_wdt_inten_rst_demo();
        
            break;
        
        
        
        case BSP_UART_BLOCK:
            
            bsp_uart_block_demo();
        
            break;
		
		
		case BSP_UART_INT:
            
            bsp_uart_int_demo();
        
            break;
		
		case BSP_UART_DMA:
            
            bsp_uart_dma_demo();
        
            break;
		
		case BSP_UART_FLOW:
            
            bsp_uart_flow_demo();
        
            break;
		
        case BSP_UART_EX_INT:
            
            bsp_uart_ex_int_demo();
        
            break;
		
		
		case BSP_I2C_EEPROM:
			
            bsp_i2c_eeprom_demo();
        
			break;
		
		case BSP_SPI_W25QXX:
			
            bsp_spi_w25qxx_demo();
        
			break;
		
        case BSP_ADC_CHECK:
			 
            bsp_adc_check_demo();
        
			break;
        
        case BSP_ADC_INT:
			 
            bsp_adc_int_demo();
        
			break;
        
        case BSP_ADC_DMA:
			 
            bsp_adc_dma_demo();
        
			break;
        
        case BSP_ADC_TEMP:
			 
            bsp_adc_temp_demo();
        
			break;
        
        case BSP_ADC_BAT:
			 
            bsp_adc_bat_demo();
        
			break;
        
        case BSP_RNG:
			 
            bsp_rng_demo();
        
			break;
        
        case BSP_SFLASH:
            
            bsp_sflash_demo();
        
            break; 
        
        case BSP_RTC:
			
            bsp_rtc_demo();
        
			break;
		
		case BSP_AES128:
			
			bsp_aes128_demo();
		
			break;
		
		case BSP_AES256:
			
			bsp_aes256_demo();
		
			break;
        
        default:
            
            break;
        
    }
}











