/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2022-2024, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : board.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-06-24
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include "board.h"

static volatile uint32_t system_tick = 0;

static void delay_init(void);

void board_init(void)
{
    delay_init();
    
    spi_init();
    
}


static void delay_init(void)
{
    RCC_ClocksTypeDef RCC_Clocks;

    RCC_GetClocksFreq(&RCC_Clocks);

    if (SysTick_Config(RCC_Clocks.HCLK_Frequency / 1000))
    {
        while (1)
        {
        }
    }

    NVIC_SetPriority(SysTick_IRQn, 0x0);
}


void delay_ms(uint32_t delay)
{
    uint32_t tickstart = system_tick;
    uint32_t wait = delay;

    while((system_tick - tickstart) < wait)
    {
    }
}
void rf_int(void);

uint32_t hal_get_tick(void)
{
    return system_tick;
}

void SysTick_Handler(void)
{
    system_tick ++;
    rf_int();
}








